/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute;

import java.util.List;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.Request;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of otnTeTunnelPathComputeInput.
 */
public interface OtnTeTunnelPathComputeInput extends Augmentable  {

    /**
     * Returns the attribute request.
     *
     * @return request list of request
     */
    List<Request> request();

    /**
     * Sets the attribute request.
     *
     * @param request list of request
     */
    void request(List<Request> request);

    /**
     * Adds to the list of request.
     *
     * @param addTo value of request
     */
    void addToRequest(Request addTo);

}