/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.tunnelsrpcoutput;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.tunnelsrpcoutput.result.ResultEnum;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of result.
 */
public class DefaultResult extends InnerModelObject implements Result {
    protected ResultEnum result;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public ResultEnum result() {
        return result;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void result(ResultEnum result) {
        valueLeafFlags.set(LeafIdentifier.RESULT.getLeafIndex());
        this.result = result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(result, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultResult) {
            DefaultResult other = (DefaultResult) obj;
            return
                Objects.deepEquals(result, other.result) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("result=" + result)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultResult.
     */
    public DefaultResult() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}