/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.tunnelsrpcinput.tunnelinfo.type;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of tunnelP2p.
 */
public class DefaultTunnelP2p extends InnerModelObject implements TunnelP2p {
    protected String p2Pid;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String p2Pid() {
        return p2Pid;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void p2Pid(String p2Pid) {
        valueLeafFlags.set(LeafIdentifier.P2PID.getLeafIndex());
        this.p2Pid = p2Pid;
    }

    @Override
    public int hashCode() {
        return Objects.hash(p2Pid, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnelP2p) {
            DefaultTunnelP2p other = (DefaultTunnelP2p) obj;
            return
                Objects.deepEquals(p2Pid, other.p2Pid) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("p2Pid=" + p2Pid)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnelP2p.
     */
    public DefaultTunnelP2p() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}