/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.tunnelsrpcinput.TunnelInfo;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of tunnelsRpcInput.
 */
public class DefaultTunnelsRpcInput extends InnerModelObject implements TunnelsRpcInput {
    protected TunnelInfo tunnelInfo;

    @Override
    public TunnelInfo tunnelInfo() {
        return tunnelInfo;
    }

    @Override
    public void tunnelInfo(TunnelInfo tunnelInfo) {
        this.tunnelInfo = tunnelInfo;
    }

    @Override
    public int hashCode() {
        return Objects.hash(tunnelInfo);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnelsRpcInput) {
            DefaultTunnelsRpcInput other = (DefaultTunnelsRpcInput) obj;
            return
                Objects.deepEquals(tunnelInfo, other.tunnelInfo);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tunnelInfo=" + tunnelInfo)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnelsRpcInput.
     */
    public DefaultTunnelsRpcInput() {
    }

}