/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2mpproperties.Config;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2mpproperties.State;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of tunnelP2Mp.
 */
public interface TunnelP2Mp extends Augmentable  {

    /**
     * Identify the leaf of TunnelP2Mp.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents identifier.
         */
        IDENTIFIER(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    Object name();

    /**
     * Returns the attribute identifier.
     *
     * @return identifier value of identifier
     */
    Object identifier();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute config.
     *
     * @return config value of config
     */
    Config config();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    State state();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(Object name);

    /**
     * Sets the attribute identifier.
     *
     * @param identifier value of identifier
     */
    void identifier(Object identifier);

    /**
     * Sets the attribute config.
     *
     * @param config value of config
     */
    void config(Config config);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(State state);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}