/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2mpproperties.Config;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2mpproperties.State;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of tunnelP2Mp.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTunnelP2Mp extends InnerModelObject 
        implements TunnelP2Mp, MultiInstanceObject<TunnelP2MpKeys> {
    protected Object name;
    protected Object identifier;
    protected BitSet valueLeafFlags = new BitSet();
    protected Config config;
    protected State state;

    @Override
    public Object name() {
        return name;
    }

    @Override
    public Object identifier() {
        return identifier;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public void name(Object name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void identifier(Object identifier) {
        valueLeafFlags.set(LeafIdentifier.IDENTIFIER.getLeafIndex());
        this.identifier = identifier;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, identifier, valueLeafFlags, config, state);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnelP2Mp) {
            DefaultTunnelP2Mp other = (DefaultTunnelP2Mp) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(identifier, other.identifier) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(config, other.config) &&
                Objects.deepEquals(state, other.state);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("identifier=" + identifier)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("config=" + config)
            .add("state=" + state)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnelP2Mp.
     */
    public DefaultTunnelP2Mp() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}