/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths.candidatep2psecondarypath;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathSetupProtocol;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of config.
 */
public interface Config extends Augmentable  {

    /**
     * Identify the leaf of Config.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents secondaryPath.
         */
        SECONDARYPATH(1),
        /**
         * Represents priority.
         */
        PRIORITY(2),
        /**
         * Represents pathSetupProtocol.
         */
        PATHSETUPPROTOCOL(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute secondaryPath.
     *
     * @return secondaryPath value of secondaryPath
     */
    Object secondaryPath();

    /**
     * Returns the attribute priority.
     *
     * @return priority value of priority
     */
    int priority();

    /**
     * Returns the attribute pathSetupProtocol.
     *
     * @return pathSetupProtocol value of pathSetupProtocol
     */
    Class<? extends TePathSetupProtocol> pathSetupProtocol();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute secondaryPath.
     *
     * @param secondaryPath value of secondaryPath
     */
    void secondaryPath(Object secondaryPath);

    /**
     * Sets the attribute priority.
     *
     * @param priority value of priority
     */
    void priority(int priority);

    /**
     * Sets the attribute pathSetupProtocol.
     *
     * @param pathSetupProtocol value of pathSetupProtocol
     */
    void pathSetupProtocol(Class<? extends TePathSetupProtocol> pathSetupProtocol);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}