/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths.candidatep2psecondarypath.Config;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths.candidatep2psecondarypath.State;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of candidateP2PsecondaryPath.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCandidateP2PsecondaryPath extends InnerModelObject 
        implements CandidateP2PsecondaryPath, MultiInstanceObject<CandidateP2PsecondaryPathKeys> {
    protected Object secondaryPath;
    protected BitSet valueLeafFlags = new BitSet();
    protected Config config;
    protected State state;

    @Override
    public Object secondaryPath() {
        return secondaryPath;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public void secondaryPath(Object secondaryPath) {
        valueLeafFlags.set(LeafIdentifier.SECONDARYPATH.getLeafIndex());
        this.secondaryPath = secondaryPath;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(secondaryPath, valueLeafFlags, config, state);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCandidateP2PsecondaryPath) {
            DefaultCandidateP2PsecondaryPath other = (DefaultCandidateP2PsecondaryPath) obj;
            return
                Objects.deepEquals(secondaryPath, other.secondaryPath) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(config, other.config) &&
                Objects.deepEquals(state, other.state);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("secondaryPath=" + secondaryPath)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("config=" + config)
            .add("state=" + state)
            .toString();
    }


    /**
     * Creates an instance of defaultCandidateP2PsecondaryPath.
     */
    public DefaultCandidateP2PsecondaryPath() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}