/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspProtType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.StateType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.SwitchingCapabilities;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeGlobalId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.bidirassocproperties.Bidirectional;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pparamsconfig.HierarchicalLinkId;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected String name;
    protected Class<? extends TunnelType> type;
    protected int identifier;
    protected String description;
    protected Class<? extends SwitchingCapabilities> switchingLayer;
    protected Class<? extends LspEncodingTypes> encoding;
    protected Class<? extends LspProtType> protectionType;
    protected Class<? extends StateType> adminStatus;
    protected short preference;
    protected int reoptimizeTimer;
    protected TeGlobalId providerId;
    protected TeGlobalId clientId;
    protected TeTopologyId teTopologyId;
    protected IpAddress source;
    protected IpAddress destination;
    protected byte[] srcTpId;
    protected byte[] dstTpId;
    protected short setupPriority;
    protected short holdPriority;
    protected Class<? extends TunnelType> signalingType;
    protected BitSet valueLeafFlags = new BitSet();
    protected HierarchicalLinkId hierarchicalLinkId;
    protected Bidirectional bidirectional;

    @Override
    public String name() {
        return name;
    }

    @Override
    public Class<? extends TunnelType> type() {
        return type;
    }

    @Override
    public int identifier() {
        return identifier;
    }

    @Override
    public String description() {
        return description;
    }

    @Override
    public Class<? extends SwitchingCapabilities> switchingLayer() {
        return switchingLayer;
    }

    @Override
    public Class<? extends LspEncodingTypes> encoding() {
        return encoding;
    }

    @Override
    public Class<? extends LspProtType> protectionType() {
        return protectionType;
    }

    @Override
    public Class<? extends StateType> adminStatus() {
        return adminStatus;
    }

    @Override
    public short preference() {
        return preference;
    }

    @Override
    public int reoptimizeTimer() {
        return reoptimizeTimer;
    }

    @Override
    public TeGlobalId providerId() {
        return providerId;
    }

    @Override
    public TeGlobalId clientId() {
        return clientId;
    }

    @Override
    public TeTopologyId teTopologyId() {
        return teTopologyId;
    }

    @Override
    public IpAddress source() {
        return source;
    }

    @Override
    public IpAddress destination() {
        return destination;
    }

    @Override
    public byte[] srcTpId() {
        return srcTpId;
    }

    @Override
    public byte[] dstTpId() {
        return dstTpId;
    }

    @Override
    public short setupPriority() {
        return setupPriority;
    }

    @Override
    public short holdPriority() {
        return holdPriority;
    }

    @Override
    public Class<? extends TunnelType> signalingType() {
        return signalingType;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public HierarchicalLinkId hierarchicalLinkId() {
        return hierarchicalLinkId;
    }

    @Override
    public Bidirectional bidirectional() {
        return bidirectional;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void type(Class<? extends TunnelType> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void identifier(int identifier) {
        valueLeafFlags.set(LeafIdentifier.IDENTIFIER.getLeafIndex());
        this.identifier = identifier;
    }

    @Override
    public void description(String description) {
        valueLeafFlags.set(LeafIdentifier.DESCRIPTION.getLeafIndex());
        this.description = description;
    }

    @Override
    public void switchingLayer(Class<? extends SwitchingCapabilities> switchingLayer) {
        valueLeafFlags.set(LeafIdentifier.SWITCHINGLAYER.getLeafIndex());
        this.switchingLayer = switchingLayer;
    }

    @Override
    public void encoding(Class<? extends LspEncodingTypes> encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void protectionType(Class<? extends LspProtType> protectionType) {
        valueLeafFlags.set(LeafIdentifier.PROTECTIONTYPE.getLeafIndex());
        this.protectionType = protectionType;
    }

    @Override
    public void adminStatus(Class<? extends StateType> adminStatus) {
        valueLeafFlags.set(LeafIdentifier.ADMINSTATUS.getLeafIndex());
        this.adminStatus = adminStatus;
    }

    @Override
    public void preference(short preference) {
        valueLeafFlags.set(LeafIdentifier.PREFERENCE.getLeafIndex());
        this.preference = preference;
    }

    @Override
    public void reoptimizeTimer(int reoptimizeTimer) {
        valueLeafFlags.set(LeafIdentifier.REOPTIMIZETIMER.getLeafIndex());
        this.reoptimizeTimer = reoptimizeTimer;
    }

    @Override
    public void providerId(TeGlobalId providerId) {
        valueLeafFlags.set(LeafIdentifier.PROVIDERID.getLeafIndex());
        this.providerId = providerId;
    }

    @Override
    public void clientId(TeGlobalId clientId) {
        valueLeafFlags.set(LeafIdentifier.CLIENTID.getLeafIndex());
        this.clientId = clientId;
    }

    @Override
    public void teTopologyId(TeTopologyId teTopologyId) {
        valueLeafFlags.set(LeafIdentifier.TETOPOLOGYID.getLeafIndex());
        this.teTopologyId = teTopologyId;
    }

    @Override
    public void source(IpAddress source) {
        valueLeafFlags.set(LeafIdentifier.SOURCE.getLeafIndex());
        this.source = source;
    }

    @Override
    public void destination(IpAddress destination) {
        valueLeafFlags.set(LeafIdentifier.DESTINATION.getLeafIndex());
        this.destination = destination;
    }

    @Override
    public void srcTpId(byte[] srcTpId) {
        valueLeafFlags.set(LeafIdentifier.SRCTPID.getLeafIndex());
        this.srcTpId = srcTpId;
    }

    @Override
    public void dstTpId(byte[] dstTpId) {
        valueLeafFlags.set(LeafIdentifier.DSTTPID.getLeafIndex());
        this.dstTpId = dstTpId;
    }

    @Override
    public void setupPriority(short setupPriority) {
        valueLeafFlags.set(LeafIdentifier.SETUPPRIORITY.getLeafIndex());
        this.setupPriority = setupPriority;
    }

    @Override
    public void holdPriority(short holdPriority) {
        valueLeafFlags.set(LeafIdentifier.HOLDPRIORITY.getLeafIndex());
        this.holdPriority = holdPriority;
    }

    @Override
    public void signalingType(Class<? extends TunnelType> signalingType) {
        valueLeafFlags.set(LeafIdentifier.SIGNALINGTYPE.getLeafIndex());
        this.signalingType = signalingType;
    }

    @Override
    public void hierarchicalLinkId(HierarchicalLinkId hierarchicalLinkId) {
        this.hierarchicalLinkId = hierarchicalLinkId;
    }

    @Override
    public void bidirectional(Bidirectional bidirectional) {
        this.bidirectional = bidirectional;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, type, identifier, description, switchingLayer, encoding, protectionType, adminStatus, preference, reoptimizeTimer, providerId, clientId, teTopologyId, source, destination, srcTpId, dstTpId, setupPriority, holdPriority, signalingType, valueLeafFlags, hierarchicalLinkId, bidirectional);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(identifier, other.identifier) &&
                Objects.deepEquals(description, other.description) &&
                Objects.deepEquals(switchingLayer, other.switchingLayer) &&
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(protectionType, other.protectionType) &&
                Objects.deepEquals(adminStatus, other.adminStatus) &&
                Objects.deepEquals(preference, other.preference) &&
                Objects.deepEquals(reoptimizeTimer, other.reoptimizeTimer) &&
                Objects.deepEquals(providerId, other.providerId) &&
                Objects.deepEquals(clientId, other.clientId) &&
                Objects.deepEquals(teTopologyId, other.teTopologyId) &&
                Objects.deepEquals(source, other.source) &&
                Objects.deepEquals(destination, other.destination) &&
                Objects.deepEquals(srcTpId, other.srcTpId) &&
                Objects.deepEquals(dstTpId, other.dstTpId) &&
                Objects.deepEquals(setupPriority, other.setupPriority) &&
                Objects.deepEquals(holdPriority, other.holdPriority) &&
                Objects.deepEquals(signalingType, other.signalingType) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(hierarchicalLinkId, other.hierarchicalLinkId) &&
                Objects.deepEquals(bidirectional, other.bidirectional);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("type=" + type)
            .add("identifier=" + identifier)
            .add("description=" + description)
            .add("switchingLayer=" + switchingLayer)
            .add("encoding=" + encoding)
            .add("protectionType=" + protectionType)
            .add("adminStatus=" + adminStatus)
            .add("preference=" + preference)
            .add("reoptimizeTimer=" + reoptimizeTimer)
            .add("providerId=" + providerId)
            .add("clientId=" + clientId)
            .add("teTopologyId=" + teTopologyId)
            .add("source=" + source)
            .add("destination=" + destination)
            .add("srcTpId=" + srcTpId)
            .add("dstTpId=" + dstTpId)
            .add("setupPriority=" + setupPriority)
            .add("holdPriority=" + holdPriority)
            .add("signalingType=" + signalingType)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("hierarchicalLinkId=" + hierarchicalLinkId)
            .add("bidirectional=" + bidirectional)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}