/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2mpproperties;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspProtType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.StateType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected String name;
    protected Class<? extends TunnelType> type;
    protected int identifier;
    protected String description;
    protected short setupPriority;
    protected short holdPriority;
    protected Class<? extends LspProtType> lspProtectionType;
    protected Class<? extends StateType> adminStatus;
    protected int reoptimizeTimer;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String name() {
        return name;
    }

    @Override
    public Class<? extends TunnelType> type() {
        return type;
    }

    @Override
    public int identifier() {
        return identifier;
    }

    @Override
    public String description() {
        return description;
    }

    @Override
    public short setupPriority() {
        return setupPriority;
    }

    @Override
    public short holdPriority() {
        return holdPriority;
    }

    @Override
    public Class<? extends LspProtType> lspProtectionType() {
        return lspProtectionType;
    }

    @Override
    public Class<? extends StateType> adminStatus() {
        return adminStatus;
    }

    @Override
    public int reoptimizeTimer() {
        return reoptimizeTimer;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void type(Class<? extends TunnelType> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void identifier(int identifier) {
        valueLeafFlags.set(LeafIdentifier.IDENTIFIER.getLeafIndex());
        this.identifier = identifier;
    }

    @Override
    public void description(String description) {
        valueLeafFlags.set(LeafIdentifier.DESCRIPTION.getLeafIndex());
        this.description = description;
    }

    @Override
    public void setupPriority(short setupPriority) {
        valueLeafFlags.set(LeafIdentifier.SETUPPRIORITY.getLeafIndex());
        this.setupPriority = setupPriority;
    }

    @Override
    public void holdPriority(short holdPriority) {
        valueLeafFlags.set(LeafIdentifier.HOLDPRIORITY.getLeafIndex());
        this.holdPriority = holdPriority;
    }

    @Override
    public void lspProtectionType(Class<? extends LspProtType> lspProtectionType) {
        valueLeafFlags.set(LeafIdentifier.LSPPROTECTIONTYPE.getLeafIndex());
        this.lspProtectionType = lspProtectionType;
    }

    @Override
    public void adminStatus(Class<? extends StateType> adminStatus) {
        valueLeafFlags.set(LeafIdentifier.ADMINSTATUS.getLeafIndex());
        this.adminStatus = adminStatus;
    }

    @Override
    public void reoptimizeTimer(int reoptimizeTimer) {
        valueLeafFlags.set(LeafIdentifier.REOPTIMIZETIMER.getLeafIndex());
        this.reoptimizeTimer = reoptimizeTimer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, type, identifier, description, setupPriority, holdPriority, lspProtectionType, adminStatus, reoptimizeTimer, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(identifier, other.identifier) &&
                Objects.deepEquals(description, other.description) &&
                Objects.deepEquals(setupPriority, other.setupPriority) &&
                Objects.deepEquals(holdPriority, other.holdPriority) &&
                Objects.deepEquals(lspProtectionType, other.lspProtectionType) &&
                Objects.deepEquals(adminStatus, other.adminStatus) &&
                Objects.deepEquals(reoptimizeTimer, other.reoptimizeTimer) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("type=" + type)
            .add("identifier=" + identifier)
            .add("description=" + description)
            .add("setupPriority=" + setupPriority)
            .add("holdPriority=" + holdPriority)
            .add("lspProtectionType=" + lspProtectionType)
            .add("adminStatus=" + adminStatus)
            .add("reoptimizeTimer=" + reoptimizeTimer)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}