/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeoutput;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathproperties.PathProperties;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeoutput.result.ExplicitRouteObjects;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of result.
 */
public class DefaultResult extends InnerModelObject 
        implements Result, MultiInstanceObject<ResultKeys> {
    protected short id;
    protected BitSet valueLeafFlags = new BitSet();
    protected ExplicitRouteObjects explicitRouteObjects;
    protected PathProperties pathProperties;

    @Override
    public short id() {
        return id;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ExplicitRouteObjects explicitRouteObjects() {
        return explicitRouteObjects;
    }

    @Override
    public PathProperties pathProperties() {
        return pathProperties;
    }

    @Override
    public void id(short id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects) {
        this.explicitRouteObjects = explicitRouteObjects;
    }

    @Override
    public void pathProperties(PathProperties pathProperties) {
        this.pathProperties = pathProperties;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, valueLeafFlags, explicitRouteObjects, pathProperties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultResult) {
            DefaultResult other = (DefaultResult) obj;
            return
                Objects.deepEquals(id, other.id) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(explicitRouteObjects, other.explicitRouteObjects) &&
                Objects.deepEquals(pathProperties, other.pathProperties);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("explicitRouteObjects=" + explicitRouteObjects)
            .add("pathProperties=" + pathProperties)
            .toString();
    }


    /**
     * Creates an instance of defaultResult.
     */
    public DefaultResult() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}