/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeinput;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.SwitchingCapabilities;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeNodeId;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathconstraints.PathConstraints;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeinput.request.ExplicitRouteObjects;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of request.
 */
public interface Request extends Augmentable  {

    /**
     * Identify the leaf of Request.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents source.
         */
        SOURCE(2),
        /**
         * Represents destination.
         */
        DESTINATION(3),
        /**
         * Represents srcTpId.
         */
        SRCTPID(4),
        /**
         * Represents dstTpId.
         */
        DSTTPID(5),
        /**
         * Represents switchingLayer.
         */
        SWITCHINGLAYER(6),
        /**
         * Represents encoding.
         */
        ENCODING(7);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    short id();

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    TeNodeId source();

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    TeNodeId destination();

    /**
     * Returns the attribute srcTpId.
     *
     * @return srcTpId value of srcTpId
     */
    byte[] srcTpId();

    /**
     * Returns the attribute dstTpId.
     *
     * @return dstTpId value of dstTpId
     */
    byte[] dstTpId();

    /**
     * Returns the attribute switchingLayer.
     *
     * @return switchingLayer value of switchingLayer
     */
    Class<? extends SwitchingCapabilities> switchingLayer();

    /**
     * Returns the attribute encoding.
     *
     * @return encoding value of encoding
     */
    Class<? extends LspEncodingTypes> encoding();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute explicitRouteObjects.
     *
     * @return explicitRouteObjects value of explicitRouteObjects
     */
    ExplicitRouteObjects explicitRouteObjects();

    /**
     * Returns the attribute pathConstraints.
     *
     * @return pathConstraints value of pathConstraints
     */
    PathConstraints pathConstraints();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(short id);

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(TeNodeId source);

    /**
     * Sets the attribute destination.
     *
     * @param destination value of destination
     */
    void destination(TeNodeId destination);

    /**
     * Sets the attribute srcTpId.
     *
     * @param srcTpId value of srcTpId
     */
    void srcTpId(byte[] srcTpId);

    /**
     * Sets the attribute dstTpId.
     *
     * @param dstTpId value of dstTpId
     */
    void dstTpId(byte[] dstTpId);

    /**
     * Sets the attribute switchingLayer.
     *
     * @param switchingLayer value of switchingLayer
     */
    void switchingLayer(Class<? extends SwitchingCapabilities> switchingLayer);

    /**
     * Sets the attribute encoding.
     *
     * @param encoding value of encoding
     */
    void encoding(Class<? extends LspEncodingTypes> encoding);

    /**
     * Sets the attribute explicitRouteObjects.
     *
     * @param explicitRouteObjects value of explicitRouteObjects
     */
    void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects);

    /**
     * Sets the attribute pathConstraints.
     *
     * @param pathConstraints value of pathConstraints
     */
    void pathConstraints(PathConstraints pathConstraints);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}