/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeinput;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.SwitchingCapabilities;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeNodeId;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathconstraints.PathConstraints;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeinput.request.ExplicitRouteObjects;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of request.
 */
public class DefaultRequest extends InnerModelObject 
        implements Request, MultiInstanceObject<RequestKeys> {
    protected short id;
    protected TeNodeId source;
    protected TeNodeId destination;
    protected byte[] srcTpId;
    protected byte[] dstTpId;
    protected Class<? extends SwitchingCapabilities> switchingLayer;
    protected Class<? extends LspEncodingTypes> encoding;
    protected BitSet valueLeafFlags = new BitSet();
    protected ExplicitRouteObjects explicitRouteObjects;
    protected PathConstraints pathConstraints;

    @Override
    public short id() {
        return id;
    }

    @Override
    public TeNodeId source() {
        return source;
    }

    @Override
    public TeNodeId destination() {
        return destination;
    }

    @Override
    public byte[] srcTpId() {
        return srcTpId;
    }

    @Override
    public byte[] dstTpId() {
        return dstTpId;
    }

    @Override
    public Class<? extends SwitchingCapabilities> switchingLayer() {
        return switchingLayer;
    }

    @Override
    public Class<? extends LspEncodingTypes> encoding() {
        return encoding;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ExplicitRouteObjects explicitRouteObjects() {
        return explicitRouteObjects;
    }

    @Override
    public PathConstraints pathConstraints() {
        return pathConstraints;
    }

    @Override
    public void id(short id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void source(TeNodeId source) {
        valueLeafFlags.set(LeafIdentifier.SOURCE.getLeafIndex());
        this.source = source;
    }

    @Override
    public void destination(TeNodeId destination) {
        valueLeafFlags.set(LeafIdentifier.DESTINATION.getLeafIndex());
        this.destination = destination;
    }

    @Override
    public void srcTpId(byte[] srcTpId) {
        valueLeafFlags.set(LeafIdentifier.SRCTPID.getLeafIndex());
        this.srcTpId = srcTpId;
    }

    @Override
    public void dstTpId(byte[] dstTpId) {
        valueLeafFlags.set(LeafIdentifier.DSTTPID.getLeafIndex());
        this.dstTpId = dstTpId;
    }

    @Override
    public void switchingLayer(Class<? extends SwitchingCapabilities> switchingLayer) {
        valueLeafFlags.set(LeafIdentifier.SWITCHINGLAYER.getLeafIndex());
        this.switchingLayer = switchingLayer;
    }

    @Override
    public void encoding(Class<? extends LspEncodingTypes> encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects) {
        this.explicitRouteObjects = explicitRouteObjects;
    }

    @Override
    public void pathConstraints(PathConstraints pathConstraints) {
        this.pathConstraints = pathConstraints;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, source, destination, srcTpId, dstTpId, switchingLayer, encoding, valueLeafFlags, explicitRouteObjects, pathConstraints);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRequest) {
            DefaultRequest other = (DefaultRequest) obj;
            return
                Objects.deepEquals(id, other.id) &&
                Objects.deepEquals(source, other.source) &&
                Objects.deepEquals(destination, other.destination) &&
                Objects.deepEquals(srcTpId, other.srcTpId) &&
                Objects.deepEquals(dstTpId, other.dstTpId) &&
                Objects.deepEquals(switchingLayer, other.switchingLayer) &&
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(explicitRouteObjects, other.explicitRouteObjects) &&
                Objects.deepEquals(pathConstraints, other.pathConstraints);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("source=" + source)
            .add("destination=" + destination)
            .add("srcTpId=" + srcTpId)
            .add("dstTpId=" + dstTpId)
            .add("switchingLayer=" + switchingLayer)
            .add("encoding=" + encoding)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("explicitRouteObjects=" + explicitRouteObjects)
            .add("pathConstraints=" + pathConstraints)
            .toString();
    }


    /**
     * Creates an instance of defaultRequest.
     */
    public DefaultRequest() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}