/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathDisjointness;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.OptimizationCriterion;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeinput.Request;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of teTunnelPathComputeInput.
 */
public interface TeTunnelPathComputeInput extends Augmentable  {

    /**
     * Identify the leaf of TeTunnelPathComputeInput.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents interRequestDiversity.
         */
        INTERREQUESTDIVERSITY(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute interRequestDiversity.
     *
     * @return interRequestDiversity value of interRequestDiversity
     */
    TePathDisjointness interRequestDiversity();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute request.
     *
     * @return request list of request
     */
    List<Request> request();

    /**
     * Returns the attribute optimizationCriterion.
     *
     * @return optimizationCriterion value of optimizationCriterion
     */
    OptimizationCriterion optimizationCriterion();

    /**
     * Sets the attribute interRequestDiversity.
     *
     * @param interRequestDiversity value of interRequestDiversity
     */
    void interRequestDiversity(TePathDisjointness interRequestDiversity);

    /**
     * Sets the attribute request.
     *
     * @param request list of request
     */
    void request(List<Request> request);

    /**
     * Sets the attribute optimizationCriterion.
     *
     * @param optimizationCriterion value of optimizationCriterion
     */
    void optimizationCriterion(OptimizationCriterion optimizationCriterion);

    /**
     * Adds to the list of request.
     *
     * @param addTo value of request
     */
    void addToRequest(Request addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}