/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeoutput.Result;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeoutput.ReturnCodeEnum;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of teTunnelPathComputeOutput.
 */
public class DefaultTeTunnelPathComputeOutput extends InnerModelObject implements TeTunnelPathComputeOutput {
    protected ReturnCodeEnum returnCode;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<Result> result;

    @Override
    public ReturnCodeEnum returnCode() {
        return returnCode;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<Result> result() {
        return result;
    }

    @Override
    public void returnCode(ReturnCodeEnum returnCode) {
        valueLeafFlags.set(LeafIdentifier.RETURNCODE.getLeafIndex());
        this.returnCode = returnCode;
    }

    @Override
    public void result(List<Result> result) {
        this.result = result;
    }

    @Override
    public void addToResult(Result addTo) {
        if (result == null) {
            result = new ArrayList<>();
        }
        result.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(returnCode, valueLeafFlags, result);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeTunnelPathComputeOutput) {
            DefaultTeTunnelPathComputeOutput other = (DefaultTeTunnelPathComputeOutput) obj;
            return
                Objects.deepEquals(returnCode, other.returnCode) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(result, other.result);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("returnCode=" + returnCode)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("result=" + result)
            .toString();
    }


    /**
     * Creates an instance of defaultTeTunnelPathComputeOutput.
     */
    public DefaultTeTunnelPathComputeOutput() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}