/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathDisjointness;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.OptimizationCriterion;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.tetunnelpathcomputeinput.Request;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of teTunnelPathComputeInput.
 */
public class DefaultTeTunnelPathComputeInput extends InnerModelObject implements TeTunnelPathComputeInput {
    protected TePathDisjointness interRequestDiversity;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<Request> request;
    protected OptimizationCriterion optimizationCriterion;

    @Override
    public TePathDisjointness interRequestDiversity() {
        return interRequestDiversity;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<Request> request() {
        return request;
    }

    @Override
    public OptimizationCriterion optimizationCriterion() {
        return optimizationCriterion;
    }

    @Override
    public void interRequestDiversity(TePathDisjointness interRequestDiversity) {
        valueLeafFlags.set(LeafIdentifier.INTERREQUESTDIVERSITY.getLeafIndex());
        this.interRequestDiversity = interRequestDiversity;
    }

    @Override
    public void request(List<Request> request) {
        this.request = request;
    }

    @Override
    public void optimizationCriterion(OptimizationCriterion optimizationCriterion) {
        this.optimizationCriterion = optimizationCriterion;
    }

    @Override
    public void addToRequest(Request addTo) {
        if (request == null) {
            request = new ArrayList<>();
        }
        request.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(interRequestDiversity, valueLeafFlags, request, optimizationCriterion);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeTunnelPathComputeInput) {
            DefaultTeTunnelPathComputeInput other = (DefaultTeTunnelPathComputeInput) obj;
            return
                Objects.deepEquals(interRequestDiversity, other.interRequestDiversity) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(request, other.request) &&
                Objects.deepEquals(optimizationCriterion, other.optimizationCriterion);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("interRequestDiversity=" + interRequestDiversity)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("request=" + request)
            .add("optimizationCriterion=" + optimizationCriterion)
            .toString();
    }


    /**
     * Creates an instance of defaultTeTunnelPathComputeInput.
     */
    public DefaultTeTunnelPathComputeInput() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}