/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.overflow;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.Percentage;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State extends Augmentable  {

    /**
     * Identify the leaf of State.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents enabled.
         */
        ENABLED(1),
        /**
         * Represents overflowThreshold.
         */
        OVERFLOWTHRESHOLD(2),
        /**
         * Represents triggerEventCount.
         */
        TRIGGEREVENTCOUNT(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute enabled.
     *
     * @return enabled value of enabled
     */
    boolean enabled();

    /**
     * Returns the attribute overflowThreshold.
     *
     * @return overflowThreshold value of overflowThreshold
     */
    Percentage overflowThreshold();

    /**
     * Returns the attribute triggerEventCount.
     *
     * @return triggerEventCount value of triggerEventCount
     */
    int triggerEventCount();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute enabled.
     *
     * @param enabled value of enabled
     */
    void enabled(boolean enabled);

    /**
     * Sets the attribute overflowThreshold.
     *
     * @param overflowThreshold value of overflowThreshold
     */
    void overflowThreshold(Percentage overflowThreshold);

    /**
     * Sets the attribute triggerEventCount.
     *
     * @param triggerEventCount value of triggerEventCount
     */
    void triggerEventCount(int triggerEventCount);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}