/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeDsClass;
import org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.BandwidthKbps;
import org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.TeBandwidthType;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of config.
 */
public interface Config extends Augmentable  {

    /**
     * Identify the leaf of Config.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents specificationType.
         */
        SPECIFICATIONTYPE(1),
        /**
         * Represents setBandwidth.
         */
        SETBANDWIDTH(2),
        /**
         * Represents classType.
         */
        CLASSTYPE(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute specificationType.
     *
     * @return specificationType value of specificationType
     */
    TeBandwidthType specificationType();

    /**
     * Returns the attribute setBandwidth.
     *
     * @return setBandwidth value of setBandwidth
     */
    BandwidthKbps setBandwidth();

    /**
     * Returns the attribute classType.
     *
     * @return classType value of classType
     */
    TeDsClass classType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute specificationType.
     *
     * @param specificationType value of specificationType
     */
    void specificationType(TeBandwidthType specificationType);

    /**
     * Sets the attribute setBandwidth.
     *
     * @param setBandwidth value of setBandwidth
     */
    void setBandwidth(BandwidthKbps setBandwidth);

    /**
     * Sets the attribute classType.
     *
     * @param classType value of classType
     */
    void classType(TeDsClass classType);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}