/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathproperties;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeBandwidth;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathaffinities.PathAffinities;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathsrlgs.PathSrlgs;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathproperties.pathproperties.Metric;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of pathProperties.
 */
public interface PathProperties extends Augmentable  {

    /**
     * Identify the leaf of PathProperties.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents bandwidthGeneric.
         */
        BANDWIDTHGENERIC(1),
        /**
         * Represents setupPriority.
         */
        SETUPPRIORITY(2),
        /**
         * Represents holdPriority.
         */
        HOLDPRIORITY(3),
        /**
         * Represents ignoreOverload.
         */
        IGNOREOVERLOAD(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute bandwidthGeneric.
     *
     * @return bandwidthGeneric value of bandwidthGeneric
     */
    TeBandwidth bandwidthGeneric();

    /**
     * Returns the attribute setupPriority.
     *
     * @return setupPriority value of setupPriority
     */
    short setupPriority();

    /**
     * Returns the attribute holdPriority.
     *
     * @return holdPriority value of holdPriority
     */
    short holdPriority();

    /**
     * Returns the attribute ignoreOverload.
     *
     * @return ignoreOverload value of ignoreOverload
     */
    boolean ignoreOverload();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute metric.
     *
     * @return metric list of metric
     */
    List<Metric> metric();

    /**
     * Returns the attribute pathAffinities.
     *
     * @return pathAffinities value of pathAffinities
     */
    PathAffinities pathAffinities();

    /**
     * Returns the attribute pathSrlgs.
     *
     * @return pathSrlgs value of pathSrlgs
     */
    PathSrlgs pathSrlgs();

    /**
     * Sets the attribute bandwidthGeneric.
     *
     * @param bandwidthGeneric value of bandwidthGeneric
     */
    void bandwidthGeneric(TeBandwidth bandwidthGeneric);

    /**
     * Sets the attribute setupPriority.
     *
     * @param setupPriority value of setupPriority
     */
    void setupPriority(short setupPriority);

    /**
     * Sets the attribute holdPriority.
     *
     * @param holdPriority value of holdPriority
     */
    void holdPriority(short holdPriority);

    /**
     * Sets the attribute ignoreOverload.
     *
     * @param ignoreOverload value of ignoreOverload
     */
    void ignoreOverload(boolean ignoreOverload);

    /**
     * Sets the attribute metric.
     *
     * @param metric list of metric
     */
    void metric(List<Metric> metric);

    /**
     * Sets the attribute pathAffinities.
     *
     * @param pathAffinities value of pathAffinities
     */
    void pathAffinities(PathAffinities pathAffinities);

    /**
     * Sets the attribute pathSrlgs.
     *
     * @param pathSrlgs value of pathSrlgs
     */
    void pathSrlgs(PathSrlgs pathSrlgs);

    /**
     * Adds to the list of metric.
     *
     * @param addTo value of metric
     */
    void addToMetric(Metric addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}