/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion.metric;

/**
 * Represents ENUM data of goalEnum.
 */
public enum GoalEnum {

    /**
     * Represents minimize.
     */
    MINIMIZE(0, "minimize"),

    /**
     * Represents maxmize.
     */
    MAXMIZE(1, "maxmize");

    private int goalEnum;
    private String schemaName;

    /**
     * Creates an instance of goalEnum.
     *
     * @param goalEnum value of goalEnum
     */
     GoalEnum(int goalEnum, String schemaName) {
        this.goalEnum = goalEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of goalEnum for.
     *
     * @param value value of goalEnum for
     * @return goalEnum for
     */
    public static GoalEnum of(int value) {
        switch (value) {
            case 0:
                return GoalEnum.MINIMIZE;
            case 1:
                return GoalEnum.MAXMIZE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of goalEnum for.
     *
     * @param value value of goalEnum for
     * @return goalEnum for
     */
    public static GoalEnum of(String value) {
        switch (value) {
            case "minimize":
                return GoalEnum.MINIMIZE;
            case "maxmize":
                return GoalEnum.MAXMIZE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute goalEnum.
     *
     * @return goalEnum value of goalEnum
     */
    public int goalEnum() {
        return goalEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
