/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion.Metric;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion.Tiebreaker;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of optimizationCriterion.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultOptimizationCriterion extends InnerModelObject implements OptimizationCriterion {
    protected List<Metric> metric;
    protected List<Tiebreaker> tiebreaker;

    @Override
    public List<Metric> metric() {
        return metric;
    }

    @Override
    public List<Tiebreaker> tiebreaker() {
        return tiebreaker;
    }

    @Override
    public void metric(List<Metric> metric) {
        this.metric = metric;
    }

    @Override
    public void tiebreaker(List<Tiebreaker> tiebreaker) {
        this.tiebreaker = tiebreaker;
    }

    @Override
    public void addToMetric(Metric addTo) {
        if (metric == null) {
            metric = new ArrayList<>();
        }
        metric.add(addTo);
    }


    @Override
    public void addToTiebreaker(Tiebreaker addTo) {
        if (tiebreaker == null) {
            tiebreaker = new ArrayList<>();
        }
        tiebreaker.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(metric, tiebreaker);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultOptimizationCriterion) {
            DefaultOptimizationCriterion other = (DefaultOptimizationCriterion) obj;
            return
                Objects.deepEquals(metric, other.metric) &&
                Objects.deepEquals(tiebreaker, other.tiebreaker);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("metric=" + metric)
            .add("tiebreaker=" + tiebreaker)
            .toString();
    }


    /**
     * Creates an instance of defaultOptimizationCriterion.
     */
    public DefaultOptimizationCriterion() {
    }

}