/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2psecondarypathpropertiesstate;

import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of lsp.
 */
public class LspKeys implements KeyInfo<DefaultLsp> {
    protected Object source;
    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    public Object source() {
        return source;
    }

    /**
     * Sets the value to attribute source.
     *
     * @param source value of source
     */
    public void source(Object source) {
        this.source = source;
    }


    @Override
    public int hashCode() {
        return Objects.hash(source);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LspKeys) {
            LspKeys other = (LspKeys) obj;
            return
                Objects.deepEquals(source, other.source);
        }
        return false;
    }
}