/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2pprimarypathpropertiesstate.lsps;

import java.lang.Object;
import java.lang.Object;
import java.lang.Object;
import java.lang.Object;
import java.lang.Object;
import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of lsp.
 */
public class LspKeys implements KeyInfo<DefaultLsp> {
    protected Object source;
    protected Object destination;
    protected Object tunnelId;
    protected Object lspId;
    protected Object extendedTunnelId;
    protected Object type;
    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    public Object source() {
        return source;
    }

    /**
     * Sets the value to attribute source.
     *
     * @param source value of source
     */
    public void source(Object source) {
        this.source = source;
    }

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    public Object destination() {
        return destination;
    }

    /**
     * Sets the value to attribute destination.
     *
     * @param destination value of destination
     */
    public void destination(Object destination) {
        this.destination = destination;
    }

    /**
     * Returns the attribute tunnelId.
     *
     * @return tunnelId value of tunnelId
     */
    public Object tunnelId() {
        return tunnelId;
    }

    /**
     * Sets the value to attribute tunnelId.
     *
     * @param tunnelId value of tunnelId
     */
    public void tunnelId(Object tunnelId) {
        this.tunnelId = tunnelId;
    }

    /**
     * Returns the attribute lspId.
     *
     * @return lspId value of lspId
     */
    public Object lspId() {
        return lspId;
    }

    /**
     * Sets the value to attribute lspId.
     *
     * @param lspId value of lspId
     */
    public void lspId(Object lspId) {
        this.lspId = lspId;
    }

    /**
     * Returns the attribute extendedTunnelId.
     *
     * @return extendedTunnelId value of extendedTunnelId
     */
    public Object extendedTunnelId() {
        return extendedTunnelId;
    }

    /**
     * Sets the value to attribute extendedTunnelId.
     *
     * @param extendedTunnelId value of extendedTunnelId
     */
    public void extendedTunnelId(Object extendedTunnelId) {
        this.extendedTunnelId = extendedTunnelId;
    }

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    public Object type() {
        return type;
    }

    /**
     * Sets the value to attribute type.
     *
     * @param type value of type
     */
    public void type(Object type) {
        this.type = type;
    }


    @Override
    public int hashCode() {
        return Objects.hash(source, destination, tunnelId, lspId, extendedTunnelId, type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LspKeys) {
            LspKeys other = (LspKeys) obj;
            return
                Objects.deepEquals(source, other.source) &&
                Objects.deepEquals(destination, other.destination) &&
                Objects.deepEquals(tunnelId, other.tunnelId) &&
                Objects.deepEquals(lspId, other.lspId) &&
                Objects.deepEquals(extendedTunnelId, other.extendedTunnelId) &&
                Objects.deepEquals(type, other.type);
        }
        return false;
    }
}