/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2pprimarypathpropertiesstate.lsps;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathSignalingType;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of lsp.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLsp extends InnerModelObject 
        implements Lsp, MultiInstanceObject<LspKeys> {
    protected Object source;
    protected Object destination;
    protected Object tunnelId;
    protected Object lspId;
    protected Object extendedTunnelId;
    protected Object type;
    protected Class<? extends PathSignalingType> signalingType;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Object source() {
        return source;
    }

    @Override
    public Object destination() {
        return destination;
    }

    @Override
    public Object tunnelId() {
        return tunnelId;
    }

    @Override
    public Object lspId() {
        return lspId;
    }

    @Override
    public Object extendedTunnelId() {
        return extendedTunnelId;
    }

    @Override
    public Object type() {
        return type;
    }

    @Override
    public Class<? extends PathSignalingType> signalingType() {
        return signalingType;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void source(Object source) {
        valueLeafFlags.set(LeafIdentifier.SOURCE.getLeafIndex());
        this.source = source;
    }

    @Override
    public void destination(Object destination) {
        valueLeafFlags.set(LeafIdentifier.DESTINATION.getLeafIndex());
        this.destination = destination;
    }

    @Override
    public void tunnelId(Object tunnelId) {
        valueLeafFlags.set(LeafIdentifier.TUNNELID.getLeafIndex());
        this.tunnelId = tunnelId;
    }

    @Override
    public void lspId(Object lspId) {
        valueLeafFlags.set(LeafIdentifier.LSPID.getLeafIndex());
        this.lspId = lspId;
    }

    @Override
    public void extendedTunnelId(Object extendedTunnelId) {
        valueLeafFlags.set(LeafIdentifier.EXTENDEDTUNNELID.getLeafIndex());
        this.extendedTunnelId = extendedTunnelId;
    }

    @Override
    public void type(Object type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void signalingType(Class<? extends PathSignalingType> signalingType) {
        valueLeafFlags.set(LeafIdentifier.SIGNALINGTYPE.getLeafIndex());
        this.signalingType = signalingType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(source, destination, tunnelId, lspId, extendedTunnelId, type, signalingType, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLsp) {
            DefaultLsp other = (DefaultLsp) obj;
            return
                Objects.deepEquals(source, other.source) &&
                Objects.deepEquals(destination, other.destination) &&
                Objects.deepEquals(tunnelId, other.tunnelId) &&
                Objects.deepEquals(lspId, other.lspId) &&
                Objects.deepEquals(extendedTunnelId, other.extendedTunnelId) &&
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(signalingType, other.signalingType) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("source=" + source)
            .add("destination=" + destination)
            .add("tunnelId=" + tunnelId)
            .add("lspId=" + lspId)
            .add("extendedTunnelId=" + extendedTunnelId)
            .add("type=" + type)
            .add("signalingType=" + signalingType)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultLsp.
     */
    public DefaultLsp() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}