/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2pprimarypathproperties;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathComputationMethod;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathSetupProtocol;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2ppathpropertiesconfig.TeNsrlgs;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2ppathpropertiesconfig.TeSrlgs;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected String name;
    protected short preference;
    protected Class<? extends TePathSetupProtocol> pathSetupProtocol;
    protected Class<? extends PathComputationMethod> pathComputationMethod;
    protected IpAddress pathComputationServer;
    protected boolean computeOnly;
    protected boolean useCspf;
    protected boolean verbatim;
    protected boolean lockdown;
    protected long teDefaultMetric;
    protected long teDelayMetric;
    protected long teHopMetric;
    protected Object namedExplicitPath;
    protected Object namedPathConstraint;
    protected BitSet valueLeafFlags = new BitSet();
    protected TeSrlgs teSrlgs;
    protected TeNsrlgs teNsrlgs;

    @Override
    public String name() {
        return name;
    }

    @Override
    public short preference() {
        return preference;
    }

    @Override
    public Class<? extends TePathSetupProtocol> pathSetupProtocol() {
        return pathSetupProtocol;
    }

    @Override
    public Class<? extends PathComputationMethod> pathComputationMethod() {
        return pathComputationMethod;
    }

    @Override
    public IpAddress pathComputationServer() {
        return pathComputationServer;
    }

    @Override
    public boolean computeOnly() {
        return computeOnly;
    }

    @Override
    public boolean useCspf() {
        return useCspf;
    }

    @Override
    public boolean verbatim() {
        return verbatim;
    }

    @Override
    public boolean lockdown() {
        return lockdown;
    }

    @Override
    public long teDefaultMetric() {
        return teDefaultMetric;
    }

    @Override
    public long teDelayMetric() {
        return teDelayMetric;
    }

    @Override
    public long teHopMetric() {
        return teHopMetric;
    }

    @Override
    public Object namedExplicitPath() {
        return namedExplicitPath;
    }

    @Override
    public Object namedPathConstraint() {
        return namedPathConstraint;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public TeSrlgs teSrlgs() {
        return teSrlgs;
    }

    @Override
    public TeNsrlgs teNsrlgs() {
        return teNsrlgs;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void preference(short preference) {
        valueLeafFlags.set(LeafIdentifier.PREFERENCE.getLeafIndex());
        this.preference = preference;
    }

    @Override
    public void pathSetupProtocol(Class<? extends TePathSetupProtocol> pathSetupProtocol) {
        valueLeafFlags.set(LeafIdentifier.PATHSETUPPROTOCOL.getLeafIndex());
        this.pathSetupProtocol = pathSetupProtocol;
    }

    @Override
    public void pathComputationMethod(Class<? extends PathComputationMethod> pathComputationMethod) {
        valueLeafFlags.set(LeafIdentifier.PATHCOMPUTATIONMETHOD.getLeafIndex());
        this.pathComputationMethod = pathComputationMethod;
    }

    @Override
    public void pathComputationServer(IpAddress pathComputationServer) {
        valueLeafFlags.set(LeafIdentifier.PATHCOMPUTATIONSERVER.getLeafIndex());
        this.pathComputationServer = pathComputationServer;
    }

    @Override
    public void computeOnly(boolean computeOnly) {
        valueLeafFlags.set(LeafIdentifier.COMPUTEONLY.getLeafIndex());
        this.computeOnly = computeOnly;
    }

    @Override
    public void useCspf(boolean useCspf) {
        valueLeafFlags.set(LeafIdentifier.USECSPF.getLeafIndex());
        this.useCspf = useCspf;
    }

    @Override
    public void verbatim(boolean verbatim) {
        valueLeafFlags.set(LeafIdentifier.VERBATIM.getLeafIndex());
        this.verbatim = verbatim;
    }

    @Override
    public void lockdown(boolean lockdown) {
        valueLeafFlags.set(LeafIdentifier.LOCKDOWN.getLeafIndex());
        this.lockdown = lockdown;
    }

    @Override
    public void teDefaultMetric(long teDefaultMetric) {
        valueLeafFlags.set(LeafIdentifier.TEDEFAULTMETRIC.getLeafIndex());
        this.teDefaultMetric = teDefaultMetric;
    }

    @Override
    public void teDelayMetric(long teDelayMetric) {
        valueLeafFlags.set(LeafIdentifier.TEDELAYMETRIC.getLeafIndex());
        this.teDelayMetric = teDelayMetric;
    }

    @Override
    public void teHopMetric(long teHopMetric) {
        valueLeafFlags.set(LeafIdentifier.TEHOPMETRIC.getLeafIndex());
        this.teHopMetric = teHopMetric;
    }

    @Override
    public void namedExplicitPath(Object namedExplicitPath) {
        valueLeafFlags.set(LeafIdentifier.NAMEDEXPLICITPATH.getLeafIndex());
        this.namedExplicitPath = namedExplicitPath;
    }

    @Override
    public void namedPathConstraint(Object namedPathConstraint) {
        valueLeafFlags.set(LeafIdentifier.NAMEDPATHCONSTRAINT.getLeafIndex());
        this.namedPathConstraint = namedPathConstraint;
    }

    @Override
    public void teSrlgs(TeSrlgs teSrlgs) {
        this.teSrlgs = teSrlgs;
    }

    @Override
    public void teNsrlgs(TeNsrlgs teNsrlgs) {
        this.teNsrlgs = teNsrlgs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, preference, pathSetupProtocol, pathComputationMethod, pathComputationServer, computeOnly, useCspf, verbatim, lockdown, teDefaultMetric, teDelayMetric, teHopMetric, namedExplicitPath, namedPathConstraint, valueLeafFlags, teSrlgs, teNsrlgs);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(preference, other.preference) &&
                Objects.deepEquals(pathSetupProtocol, other.pathSetupProtocol) &&
                Objects.deepEquals(pathComputationMethod, other.pathComputationMethod) &&
                Objects.deepEquals(pathComputationServer, other.pathComputationServer) &&
                Objects.deepEquals(computeOnly, other.computeOnly) &&
                Objects.deepEquals(useCspf, other.useCspf) &&
                Objects.deepEquals(verbatim, other.verbatim) &&
                Objects.deepEquals(lockdown, other.lockdown) &&
                Objects.deepEquals(teDefaultMetric, other.teDefaultMetric) &&
                Objects.deepEquals(teDelayMetric, other.teDelayMetric) &&
                Objects.deepEquals(teHopMetric, other.teHopMetric) &&
                Objects.deepEquals(namedExplicitPath, other.namedExplicitPath) &&
                Objects.deepEquals(namedPathConstraint, other.namedPathConstraint) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(teSrlgs, other.teSrlgs) &&
                Objects.deepEquals(teNsrlgs, other.teNsrlgs);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("preference=" + preference)
            .add("pathSetupProtocol=" + pathSetupProtocol)
            .add("pathComputationMethod=" + pathComputationMethod)
            .add("pathComputationServer=" + pathComputationServer)
            .add("computeOnly=" + computeOnly)
            .add("useCspf=" + useCspf)
            .add("verbatim=" + verbatim)
            .add("lockdown=" + lockdown)
            .add("teDefaultMetric=" + teDefaultMetric)
            .add("teDelayMetric=" + teDelayMetric)
            .add("teHopMetric=" + teHopMetric)
            .add("namedExplicitPath=" + namedExplicitPath)
            .add("namedPathConstraint=" + namedPathConstraint)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("teSrlgs=" + teSrlgs)
            .add("teNsrlgs=" + teNsrlgs)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}