/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2pprimarypathproperties;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathComputationMethod;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathSetupProtocol;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2ppathpropertiesconfig.TeNsrlgs;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2ppathpropertiesconfig.TeSrlgs;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of config.
 */
public interface Config extends Augmentable  {

    /**
     * Identify the leaf of Config.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents preference.
         */
        PREFERENCE(2),
        /**
         * Represents pathSetupProtocol.
         */
        PATHSETUPPROTOCOL(3),
        /**
         * Represents pathComputationMethod.
         */
        PATHCOMPUTATIONMETHOD(4),
        /**
         * Represents pathComputationServer.
         */
        PATHCOMPUTATIONSERVER(5),
        /**
         * Represents computeOnly.
         */
        COMPUTEONLY(6),
        /**
         * Represents useCspf.
         */
        USECSPF(7),
        /**
         * Represents verbatim.
         */
        VERBATIM(8),
        /**
         * Represents lockdown.
         */
        LOCKDOWN(9),
        /**
         * Represents teDefaultMetric.
         */
        TEDEFAULTMETRIC(10),
        /**
         * Represents teDelayMetric.
         */
        TEDELAYMETRIC(11),
        /**
         * Represents teHopMetric.
         */
        TEHOPMETRIC(12),
        /**
         * Represents namedExplicitPath.
         */
        NAMEDEXPLICITPATH(13),
        /**
         * Represents namedPathConstraint.
         */
        NAMEDPATHCONSTRAINT(14);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute preference.
     *
     * @return preference value of preference
     */
    short preference();

    /**
     * Returns the attribute pathSetupProtocol.
     *
     * @return pathSetupProtocol value of pathSetupProtocol
     */
    Class<? extends TePathSetupProtocol> pathSetupProtocol();

    /**
     * Returns the attribute pathComputationMethod.
     *
     * @return pathComputationMethod value of pathComputationMethod
     */
    Class<? extends PathComputationMethod> pathComputationMethod();

    /**
     * Returns the attribute pathComputationServer.
     *
     * @return pathComputationServer value of pathComputationServer
     */
    IpAddress pathComputationServer();

    /**
     * Returns the attribute computeOnly.
     *
     * @return computeOnly value of computeOnly
     */
    boolean computeOnly();

    /**
     * Returns the attribute useCspf.
     *
     * @return useCspf value of useCspf
     */
    boolean useCspf();

    /**
     * Returns the attribute verbatim.
     *
     * @return verbatim value of verbatim
     */
    boolean verbatim();

    /**
     * Returns the attribute lockdown.
     *
     * @return lockdown value of lockdown
     */
    boolean lockdown();

    /**
     * Returns the attribute teDefaultMetric.
     *
     * @return teDefaultMetric value of teDefaultMetric
     */
    long teDefaultMetric();

    /**
     * Returns the attribute teDelayMetric.
     *
     * @return teDelayMetric value of teDelayMetric
     */
    long teDelayMetric();

    /**
     * Returns the attribute teHopMetric.
     *
     * @return teHopMetric value of teHopMetric
     */
    long teHopMetric();

    /**
     * Returns the attribute namedExplicitPath.
     *
     * @return namedExplicitPath value of namedExplicitPath
     */
    Object namedExplicitPath();

    /**
     * Returns the attribute namedPathConstraint.
     *
     * @return namedPathConstraint value of namedPathConstraint
     */
    Object namedPathConstraint();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute teSrlgs.
     *
     * @return teSrlgs value of teSrlgs
     */
    TeSrlgs teSrlgs();

    /**
     * Returns the attribute teNsrlgs.
     *
     * @return teNsrlgs value of teNsrlgs
     */
    TeNsrlgs teNsrlgs();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute preference.
     *
     * @param preference value of preference
     */
    void preference(short preference);

    /**
     * Sets the attribute pathSetupProtocol.
     *
     * @param pathSetupProtocol value of pathSetupProtocol
     */
    void pathSetupProtocol(Class<? extends TePathSetupProtocol> pathSetupProtocol);

    /**
     * Sets the attribute pathComputationMethod.
     *
     * @param pathComputationMethod value of pathComputationMethod
     */
    void pathComputationMethod(Class<? extends PathComputationMethod> pathComputationMethod);

    /**
     * Sets the attribute pathComputationServer.
     *
     * @param pathComputationServer value of pathComputationServer
     */
    void pathComputationServer(IpAddress pathComputationServer);

    /**
     * Sets the attribute computeOnly.
     *
     * @param computeOnly value of computeOnly
     */
    void computeOnly(boolean computeOnly);

    /**
     * Sets the attribute useCspf.
     *
     * @param useCspf value of useCspf
     */
    void useCspf(boolean useCspf);

    /**
     * Sets the attribute verbatim.
     *
     * @param verbatim value of verbatim
     */
    void verbatim(boolean verbatim);

    /**
     * Sets the attribute lockdown.
     *
     * @param lockdown value of lockdown
     */
    void lockdown(boolean lockdown);

    /**
     * Sets the attribute teDefaultMetric.
     *
     * @param teDefaultMetric value of teDefaultMetric
     */
    void teDefaultMetric(long teDefaultMetric);

    /**
     * Sets the attribute teDelayMetric.
     *
     * @param teDelayMetric value of teDelayMetric
     */
    void teDelayMetric(long teDelayMetric);

    /**
     * Sets the attribute teHopMetric.
     *
     * @param teHopMetric value of teHopMetric
     */
    void teHopMetric(long teHopMetric);

    /**
     * Sets the attribute namedExplicitPath.
     *
     * @param namedExplicitPath value of namedExplicitPath
     */
    void namedExplicitPath(Object namedExplicitPath);

    /**
     * Sets the attribute namedPathConstraint.
     *
     * @param namedPathConstraint value of namedPathConstraint
     */
    void namedPathConstraint(Object namedPathConstraint);

    /**
     * Sets the attribute teSrlgs.
     *
     * @param teSrlgs value of teSrlgs
     */
    void teSrlgs(TeSrlgs teSrlgs);

    /**
     * Sets the attribute teNsrlgs.
     *
     * @param teNsrlgs value of teNsrlgs
     */
    void teNsrlgs(TeNsrlgs teNsrlgs);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}