/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints.namedpathconstraints.namedpathconstraint;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathMetricType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathTiebreakerType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathaffinities.PathAffinities;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathrouteobjects.ExplicitRouteObjects;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathsrlgs.PathSrlgs;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathbandwidthtop.Bandwidth;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of state.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultState extends InnerModelObject implements State {
    protected String name;
    protected TeTopologyId topologyId;
    protected long costLimit;
    protected short hopLimit;
    protected Class<? extends PathMetricType> metricType;
    protected Class<? extends PathTiebreakerType> tiebreakerType;
    protected boolean ignoreOverload;
    protected short setupPriority;
    protected short holdPriority;
    protected BitSet valueLeafFlags = new BitSet();
    protected PathAffinities pathAffinities;
    protected PathSrlgs pathSrlgs;
    protected Bandwidth bandwidth;
    protected ExplicitRouteObjects explicitRouteObjects;

    @Override
    public String name() {
        return name;
    }

    @Override
    public TeTopologyId topologyId() {
        return topologyId;
    }

    @Override
    public long costLimit() {
        return costLimit;
    }

    @Override
    public short hopLimit() {
        return hopLimit;
    }

    @Override
    public Class<? extends PathMetricType> metricType() {
        return metricType;
    }

    @Override
    public Class<? extends PathTiebreakerType> tiebreakerType() {
        return tiebreakerType;
    }

    @Override
    public boolean ignoreOverload() {
        return ignoreOverload;
    }

    @Override
    public short setupPriority() {
        return setupPriority;
    }

    @Override
    public short holdPriority() {
        return holdPriority;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public PathAffinities pathAffinities() {
        return pathAffinities;
    }

    @Override
    public PathSrlgs pathSrlgs() {
        return pathSrlgs;
    }

    @Override
    public Bandwidth bandwidth() {
        return bandwidth;
    }

    @Override
    public ExplicitRouteObjects explicitRouteObjects() {
        return explicitRouteObjects;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void topologyId(TeTopologyId topologyId) {
        valueLeafFlags.set(LeafIdentifier.TOPOLOGYID.getLeafIndex());
        this.topologyId = topologyId;
    }

    @Override
    public void costLimit(long costLimit) {
        valueLeafFlags.set(LeafIdentifier.COSTLIMIT.getLeafIndex());
        this.costLimit = costLimit;
    }

    @Override
    public void hopLimit(short hopLimit) {
        valueLeafFlags.set(LeafIdentifier.HOPLIMIT.getLeafIndex());
        this.hopLimit = hopLimit;
    }

    @Override
    public void metricType(Class<? extends PathMetricType> metricType) {
        valueLeafFlags.set(LeafIdentifier.METRICTYPE.getLeafIndex());
        this.metricType = metricType;
    }

    @Override
    public void tiebreakerType(Class<? extends PathTiebreakerType> tiebreakerType) {
        valueLeafFlags.set(LeafIdentifier.TIEBREAKERTYPE.getLeafIndex());
        this.tiebreakerType = tiebreakerType;
    }

    @Override
    public void ignoreOverload(boolean ignoreOverload) {
        valueLeafFlags.set(LeafIdentifier.IGNOREOVERLOAD.getLeafIndex());
        this.ignoreOverload = ignoreOverload;
    }

    @Override
    public void setupPriority(short setupPriority) {
        valueLeafFlags.set(LeafIdentifier.SETUPPRIORITY.getLeafIndex());
        this.setupPriority = setupPriority;
    }

    @Override
    public void holdPriority(short holdPriority) {
        valueLeafFlags.set(LeafIdentifier.HOLDPRIORITY.getLeafIndex());
        this.holdPriority = holdPriority;
    }

    @Override
    public void pathAffinities(PathAffinities pathAffinities) {
        this.pathAffinities = pathAffinities;
    }

    @Override
    public void pathSrlgs(PathSrlgs pathSrlgs) {
        this.pathSrlgs = pathSrlgs;
    }

    @Override
    public void bandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    @Override
    public void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects) {
        this.explicitRouteObjects = explicitRouteObjects;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, topologyId, costLimit, hopLimit, metricType, tiebreakerType, ignoreOverload, setupPriority, holdPriority, valueLeafFlags, pathAffinities, pathSrlgs, bandwidth, explicitRouteObjects);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultState) {
            DefaultState other = (DefaultState) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(topologyId, other.topologyId) &&
                Objects.deepEquals(costLimit, other.costLimit) &&
                Objects.deepEquals(hopLimit, other.hopLimit) &&
                Objects.deepEquals(metricType, other.metricType) &&
                Objects.deepEquals(tiebreakerType, other.tiebreakerType) &&
                Objects.deepEquals(ignoreOverload, other.ignoreOverload) &&
                Objects.deepEquals(setupPriority, other.setupPriority) &&
                Objects.deepEquals(holdPriority, other.holdPriority) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(pathAffinities, other.pathAffinities) &&
                Objects.deepEquals(pathSrlgs, other.pathSrlgs) &&
                Objects.deepEquals(bandwidth, other.bandwidth) &&
                Objects.deepEquals(explicitRouteObjects, other.explicitRouteObjects);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("topologyId=" + topologyId)
            .add("costLimit=" + costLimit)
            .add("hopLimit=" + hopLimit)
            .add("metricType=" + metricType)
            .add("tiebreakerType=" + tiebreakerType)
            .add("ignoreOverload=" + ignoreOverload)
            .add("setupPriority=" + setupPriority)
            .add("holdPriority=" + holdPriority)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("pathAffinities=" + pathAffinities)
            .add("pathSrlgs=" + pathSrlgs)
            .add("bandwidth=" + bandwidth)
            .add("explicitRouteObjects=" + explicitRouteObjects)
            .toString();
    }


    /**
     * Creates an instance of defaultState.
     */
    public DefaultState() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}