/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints.namedpathconstraints.NamedPathConstraint;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of namedPathConstraints.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNamedPathConstraints extends InnerModelObject implements NamedPathConstraints {
    protected List<NamedPathConstraint> namedPathConstraint;

    @Override
    public List<NamedPathConstraint> namedPathConstraint() {
        return namedPathConstraint;
    }

    @Override
    public void namedPathConstraint(List<NamedPathConstraint> namedPathConstraint) {
        this.namedPathConstraint = namedPathConstraint;
    }

    @Override
    public void addToNamedPathConstraint(NamedPathConstraint addTo) {
        if (namedPathConstraint == null) {
            namedPathConstraint = new ArrayList<>();
        }
        namedPathConstraint.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(namedPathConstraint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNamedPathConstraints) {
            DefaultNamedPathConstraints other = (DefaultNamedPathConstraints) obj;
            return
                Objects.deepEquals(namedPathConstraint, other.namedPathConstraint);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("namedPathConstraint=" + namedPathConstraint)
            .toString();
    }


    /**
     * Creates an instance of defaultNamedPathConstraints.
     */
    public DefaultNamedPathConstraints() {
    }

}