/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedexplicitpaths.namedexplicitpaths.namedexplicitpath;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedexplicitpathsconfig.ExplicitRouteObjects;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of state.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultState extends InnerModelObject implements State {
    protected String name;
    protected BitSet valueLeafFlags = new BitSet();
    protected ExplicitRouteObjects explicitRouteObjects;

    @Override
    public String name() {
        return name;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ExplicitRouteObjects explicitRouteObjects() {
        return explicitRouteObjects;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects) {
        this.explicitRouteObjects = explicitRouteObjects;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, valueLeafFlags, explicitRouteObjects);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultState) {
            DefaultState other = (DefaultState) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(explicitRouteObjects, other.explicitRouteObjects);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("explicitRouteObjects=" + explicitRouteObjects)
            .toString();
    }


    /**
     * Creates an instance of defaultState.
     */
    public DefaultState() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}