/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedexplicitpaths;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedexplicitpaths.namedexplicitpaths.NamedExplicitPath;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of namedExplicitPaths.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNamedExplicitPaths extends InnerModelObject implements NamedExplicitPaths {
    protected List<NamedExplicitPath> namedExplicitPath;

    @Override
    public List<NamedExplicitPath> namedExplicitPath() {
        return namedExplicitPath;
    }

    @Override
    public void namedExplicitPath(List<NamedExplicitPath> namedExplicitPath) {
        this.namedExplicitPath = namedExplicitPath;
    }

    @Override
    public void addToNamedExplicitPath(NamedExplicitPath addTo) {
        if (namedExplicitPath == null) {
            namedExplicitPath = new ArrayList<>();
        }
        namedExplicitPath.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(namedExplicitPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNamedExplicitPaths) {
            DefaultNamedExplicitPaths other = (DefaultNamedExplicitPaths) obj;
            return
                Objects.deepEquals(namedExplicitPath, other.namedExplicitPath);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("namedExplicitPath=" + namedExplicitPath)
            .toString();
    }


    /**
     * Creates an instance of defaultNamedExplicitPaths.
     */
    public DefaultNamedExplicitPaths() {
    }

}