/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lspsstategrouping.lspsstate;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.StateType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathSetupProtocol;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate.LspProtectionRoleEnum;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate.LspResourceStatusEnum;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate.OriginTypeEnum;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsprecordrouteinformationstate.LspRecordRouteSubobjects;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of lsp.
 */
public interface Lsp extends Augmentable  {

    /**
     * Identify the leaf of Lsp.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents source.
         */
        SOURCE(1),
        /**
         * Represents destination.
         */
        DESTINATION(2),
        /**
         * Represents tunnelId.
         */
        TUNNELID(3),
        /**
         * Represents lspId.
         */
        LSPID(4),
        /**
         * Represents extendedTunnelId.
         */
        EXTENDEDTUNNELID(5),
        /**
         * Represents type.
         */
        TYPE(6),
        /**
         * Represents operStatus.
         */
        OPERSTATUS(7),
        /**
         * Represents pathSetupProtocol.
         */
        PATHSETUPPROTOCOL(8),
        /**
         * Represents originType.
         */
        ORIGINTYPE(9),
        /**
         * Represents lspResourceStatus.
         */
        LSPRESOURCESTATUS(10),
        /**
         * Represents lspProtectionRole.
         */
        LSPPROTECTIONROLE(11),
        /**
         * Represents lspCarryNormalTraffic.
         */
        LSPCARRYNORMALTRAFFIC(12);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    IpAddress source();

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    IpAddress destination();

    /**
     * Returns the attribute tunnelId.
     *
     * @return tunnelId value of tunnelId
     */
    int tunnelId();

    /**
     * Returns the attribute lspId.
     *
     * @return lspId value of lspId
     */
    int lspId();

    /**
     * Returns the attribute extendedTunnelId.
     *
     * @return extendedTunnelId value of extendedTunnelId
     */
    IpAddress extendedTunnelId();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends TunnelType> type();

    /**
     * Returns the attribute operStatus.
     *
     * @return operStatus value of operStatus
     */
    Class<? extends StateType> operStatus();

    /**
     * Returns the attribute pathSetupProtocol.
     *
     * @return pathSetupProtocol value of pathSetupProtocol
     */
    Class<? extends TePathSetupProtocol> pathSetupProtocol();

    /**
     * Returns the attribute originType.
     *
     * @return originType value of originType
     */
    OriginTypeEnum originType();

    /**
     * Returns the attribute lspResourceStatus.
     *
     * @return lspResourceStatus value of lspResourceStatus
     */
    LspResourceStatusEnum lspResourceStatus();

    /**
     * Returns the attribute lspProtectionRole.
     *
     * @return lspProtectionRole value of lspProtectionRole
     */
    LspProtectionRoleEnum lspProtectionRole();

    /**
     * Returns the attribute lspCarryNormalTraffic.
     *
     * @return lspCarryNormalTraffic value of lspCarryNormalTraffic
     */
    boolean lspCarryNormalTraffic();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute lspRecordRouteSubobjects.
     *
     * @return lspRecordRouteSubobjects value of lspRecordRouteSubobjects
     */
    LspRecordRouteSubobjects lspRecordRouteSubobjects();

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(IpAddress source);

    /**
     * Sets the attribute destination.
     *
     * @param destination value of destination
     */
    void destination(IpAddress destination);

    /**
     * Sets the attribute tunnelId.
     *
     * @param tunnelId value of tunnelId
     */
    void tunnelId(int tunnelId);

    /**
     * Sets the attribute lspId.
     *
     * @param lspId value of lspId
     */
    void lspId(int lspId);

    /**
     * Sets the attribute extendedTunnelId.
     *
     * @param extendedTunnelId value of extendedTunnelId
     */
    void extendedTunnelId(IpAddress extendedTunnelId);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends TunnelType> type);

    /**
     * Sets the attribute operStatus.
     *
     * @param operStatus value of operStatus
     */
    void operStatus(Class<? extends StateType> operStatus);

    /**
     * Sets the attribute pathSetupProtocol.
     *
     * @param pathSetupProtocol value of pathSetupProtocol
     */
    void pathSetupProtocol(Class<? extends TePathSetupProtocol> pathSetupProtocol);

    /**
     * Sets the attribute originType.
     *
     * @param originType value of originType
     */
    void originType(OriginTypeEnum originType);

    /**
     * Sets the attribute lspResourceStatus.
     *
     * @param lspResourceStatus value of lspResourceStatus
     */
    void lspResourceStatus(LspResourceStatusEnum lspResourceStatus);

    /**
     * Sets the attribute lspProtectionRole.
     *
     * @param lspProtectionRole value of lspProtectionRole
     */
    void lspProtectionRole(LspProtectionRoleEnum lspProtectionRole);

    /**
     * Sets the attribute lspCarryNormalTraffic.
     *
     * @param lspCarryNormalTraffic value of lspCarryNormalTraffic
     */
    void lspCarryNormalTraffic(boolean lspCarryNormalTraffic);

    /**
     * Sets the attribute lspRecordRouteSubobjects.
     *
     * @param lspRecordRouteSubobjects value of lspRecordRouteSubobjects
     */
    void lspRecordRouteSubobjects(LspRecordRouteSubobjects lspRecordRouteSubobjects);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}