/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsprecordrouteinformationstate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsprecordrouteinformationstate.lsprecordroutesubobjects.RecordRouteSubobject;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of lspRecordRouteSubobjects.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLspRecordRouteSubobjects extends InnerModelObject implements LspRecordRouteSubobjects {
    protected List<RecordRouteSubobject> recordRouteSubobject;

    @Override
    public List<RecordRouteSubobject> recordRouteSubobject() {
        return recordRouteSubobject;
    }

    @Override
    public void recordRouteSubobject(List<RecordRouteSubobject> recordRouteSubobject) {
        this.recordRouteSubobject = recordRouteSubobject;
    }

    @Override
    public void addToRecordRouteSubobject(RecordRouteSubobject addTo) {
        if (recordRouteSubobject == null) {
            recordRouteSubobject = new ArrayList<>();
        }
        recordRouteSubobject.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(recordRouteSubobject);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLspRecordRouteSubobjects) {
            DefaultLspRecordRouteSubobjects other = (DefaultLspRecordRouteSubobjects) obj;
            return
                Objects.deepEquals(recordRouteSubobject, other.recordRouteSubobject);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("recordRouteSubobject=" + recordRouteSubobject)
            .toString();
    }


    /**
     * Creates an instance of defaultLspRecordRouteSubobjects.
     */
    public DefaultLspRecordRouteSubobjects() {
    }

}