/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate;

/**
 * Represents ENUM data of originTypeEnum.
 */
public enum OriginTypeEnum {

    /**
     * Represents ingress.
     */
    INGRESS(0, "ingress"),

    /**
     * Represents egress.
     */
    EGRESS(1, "egress"),

    /**
     * Represents transit.
     */
    TRANSIT(2, "transit");

    private int originTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of originTypeEnum.
     *
     * @param originTypeEnum value of originTypeEnum
     */
     OriginTypeEnum(int originTypeEnum, String schemaName) {
        this.originTypeEnum = originTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of originTypeEnum for.
     *
     * @param value value of originTypeEnum for
     * @return originTypeEnum for
     */
    public static OriginTypeEnum of(int value) {
        switch (value) {
            case 0:
                return OriginTypeEnum.INGRESS;
            case 1:
                return OriginTypeEnum.EGRESS;
            case 2:
                return OriginTypeEnum.TRANSIT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of originTypeEnum for.
     *
     * @param value value of originTypeEnum for
     * @return originTypeEnum for
     */
    public static OriginTypeEnum of(String value) {
        switch (value) {
            case "ingress":
                return OriginTypeEnum.INGRESS;
            case "egress":
                return OriginTypeEnum.EGRESS;
            case "transit":
                return OriginTypeEnum.TRANSIT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute originTypeEnum.
     *
     * @return originTypeEnum value of originTypeEnum
     */
    public int originTypeEnum() {
        return originTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
