/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate;

/**
 * Represents ENUM data of lspResourceStatusEnum.
 */
public enum LspResourceStatusEnum {

    /**
     * Represents primary.
     */
    PRIMARY(0, "primary"),

    /**
     * Represents secondary.
     */
    SECONDARY(1, "secondary");

    private int lspResourceStatusEnum;
    private String schemaName;

    /**
     * Creates an instance of lspResourceStatusEnum.
     *
     * @param lspResourceStatusEnum value of lspResourceStatusEnum
     */
     LspResourceStatusEnum(int lspResourceStatusEnum, String schemaName) {
        this.lspResourceStatusEnum = lspResourceStatusEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lspResourceStatusEnum for.
     *
     * @param value value of lspResourceStatusEnum for
     * @return lspResourceStatusEnum for
     */
    public static LspResourceStatusEnum of(int value) {
        switch (value) {
            case 0:
                return LspResourceStatusEnum.PRIMARY;
            case 1:
                return LspResourceStatusEnum.SECONDARY;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lspResourceStatusEnum for.
     *
     * @param value value of lspResourceStatusEnum for
     * @return lspResourceStatusEnum for
     */
    public static LspResourceStatusEnum of(String value) {
        switch (value) {
            case "primary":
                return LspResourceStatusEnum.PRIMARY;
            case "secondary":
                return LspResourceStatusEnum.SECONDARY;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lspResourceStatusEnum.
     *
     * @return lspResourceStatusEnum value of lspResourceStatusEnum
     */
    public int lspResourceStatusEnum() {
        return lspResourceStatusEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
