/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate;

/**
 * Represents ENUM data of lspProtectionRoleEnum.
 */
public enum LspProtectionRoleEnum {

    /**
     * Represents working.
     */
    WORKING(0, "working"),

    /**
     * Represents protecting.
     */
    PROTECTING(1, "protecting");

    private int lspProtectionRoleEnum;
    private String schemaName;

    /**
     * Creates an instance of lspProtectionRoleEnum.
     *
     * @param lspProtectionRoleEnum value of lspProtectionRoleEnum
     */
     LspProtectionRoleEnum(int lspProtectionRoleEnum, String schemaName) {
        this.lspProtectionRoleEnum = lspProtectionRoleEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lspProtectionRoleEnum for.
     *
     * @param value value of lspProtectionRoleEnum for
     * @return lspProtectionRoleEnum for
     */
    public static LspProtectionRoleEnum of(int value) {
        switch (value) {
            case 0:
                return LspProtectionRoleEnum.WORKING;
            case 1:
                return LspProtectionRoleEnum.PROTECTING;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lspProtectionRoleEnum for.
     *
     * @param value value of lspProtectionRoleEnum for
     * @return lspProtectionRoleEnum for
     */
    public static LspProtectionRoleEnum of(String value) {
        switch (value) {
            case "working":
                return LspProtectionRoleEnum.WORKING;
            case "protecting":
                return LspProtectionRoleEnum.PROTECTING;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lspProtectionRoleEnum.
     *
     * @return lspProtectionRoleEnum value of lspProtectionRoleEnum
     */
    public int lspProtectionRoleEnum() {
        return lspProtectionRoleEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
