/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310;

import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.TeTunnelPathComputeInput;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelpathcompute.TeTunnelPathComputeOutput;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.TunnelsRpcInput;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.TunnelsRpcOutput;
import org.onosproject.yang.model.RpcInput;
import org.onosproject.yang.model.RpcOutput;
import org.onosproject.yang.model.RpcService;

/**
 * Abstraction of an entity which represents the functionality of actnIetfTe.
 */
public interface ActnIetfTeService extends RpcService {
    /**
     * Service interface of globalsRpc.
     *
     * @param inputVar input of service interface globalsRpc
     * @return rpcOutput output of service interface globalsRpc
     */
    RpcOutput globalsRpc(RpcInput inputVar);

    /**
     * Service interface of interfacesRpc.
     *
     * @param inputVar input of service interface interfacesRpc
     * @return rpcOutput output of service interface interfacesRpc
     */
    RpcOutput interfacesRpc(RpcInput inputVar);

    /**
     * Service interface of tunnelsRpc.
     *
     * @param inputVar input of service interface tunnelsRpc
     * @return rpcOutput output of service interface tunnelsRpc
     */
    RpcOutput tunnelsRpc(RpcInput inputVar);

    /**
     * Service interface of teTunnelPathCompute.
     *
     * @param inputVar input of service interface teTunnelPathCompute
     * @return rpcOutput output of service interface teTunnelPathCompute
     */
    RpcOutput teTunnelPathCompute(RpcInput inputVar);

}
