/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.Te;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of actnIetfTe.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class ActnIetfTeOpParam extends InnerModelObject implements ActnIetfTe {
    protected Te te;

    @Override
    public Te te() {
        return te;
    }

    @Override
    public void te(Te te) {
        this.te = te;
    }

    @Override
    public int hashCode() {
        return Objects.hash(te);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ActnIetfTeOpParam) {
            ActnIetfTeOpParam other = (ActnIetfTeOpParam) obj;
            return
                Objects.deepEquals(te, other.te);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("te=" + te)
            .toString();
    }

    /**
     * Creates an instance of actnIetfTeOpParam.
     */
    public ActnIetfTeOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}