/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedulestateattributes.futureexecutions;

import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of execution.
 */
public class ExecutionKeys implements KeyInfo<DefaultExecution> {
    protected DateAndTime start;
    /**
     * Returns the attribute start.
     *
     * @return start value of start
     */
    public DateAndTime start() {
        return start;
    }

    /**
     * Sets the value to attribute start.
     *
     * @param start value of start
     */
    public void start(DateAndTime start) {
        this.start = start;
    }


    @Override
    public int hashCode() {
        return Objects.hash(start);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExecutionKeys) {
            ExecutionKeys other = (ExecutionKeys) obj;
            return
                Objects.deepEquals(start, other.start);
        }
        return false;
    }
}