/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedulestateattributes.futureexecutions;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.Operation;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of execution.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultExecution extends InnerModelObject 
        implements Execution, MultiInstanceObject<ExecutionKeys> {
    protected DateAndTime start;
    protected String duration;
    protected Operation operation;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public DateAndTime start() {
        return start;
    }

    @Override
    public String duration() {
        return duration;
    }

    @Override
    public Operation operation() {
        return operation;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void start(DateAndTime start) {
        valueLeafFlags.set(LeafIdentifier.START.getLeafIndex());
        this.start = start;
    }

    @Override
    public void duration(String duration) {
        valueLeafFlags.set(LeafIdentifier.DURATION.getLeafIndex());
        this.duration = duration;
    }

    @Override
    public void operation(Operation operation) {
        valueLeafFlags.set(LeafIdentifier.OPERATION.getLeafIndex());
        this.operation = operation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(start, duration, operation, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExecution) {
            DefaultExecution other = (DefaultExecution) obj;
            return
                Objects.deepEquals(start, other.start) &&
                Objects.deepEquals(duration, other.duration) &&
                Objects.deepEquals(operation, other.operation) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("start=" + start)
            .add("duration=" + duration)
            .add("operation=" + operation)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultExecution.
     */
    public DefaultExecution() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}