/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedulestateattributes;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedulestateattributes.futureexecutions.Execution;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of futureExecutions.
 */
public interface FutureExecutions extends Augmentable  {

    /**
     * Returns the attribute execution.
     *
     * @return execution list of execution
     */
    List<Execution> execution();

    /**
     * Sets the attribute execution.
     *
     * @param execution list of execution
     */
    void execution(List<Execution> execution);

    /**
     * Adds to the list of execution.
     *
     * @param addTo value of execution
     */
    void addToExecution(Execution addTo);

}