/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.operation;

/**
 * Represents ENUM data of operationEnum.
 */
public enum OperationEnum {

    /**
     * Represents configure.
     */
    CONFIGURE(0, "configure"),

    /**
     * Represents deconfigure.
     */
    DECONFIGURE(1, "deconfigure"),

    /**
     * Represents set.
     */
    SET(2, "set"),

    /**
     * Represents reset.
     */
    RESET(3, "reset");

    private int operationEnum;
    private String schemaName;

    /**
     * Creates an instance of operationEnum.
     *
     * @param operationEnum value of operationEnum
     */
     OperationEnum(int operationEnum, String schemaName) {
        this.operationEnum = operationEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of operationEnum for.
     *
     * @param value value of operationEnum for
     * @return operationEnum for
     */
    public static OperationEnum of(int value) {
        switch (value) {
            case 0:
                return OperationEnum.CONFIGURE;
            case 1:
                return OperationEnum.DECONFIGURE;
            case 2:
                return OperationEnum.SET;
            case 3:
                return OperationEnum.RESET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of operationEnum for.
     *
     * @param value value of operationEnum for
     * @return operationEnum for
     */
    public static OperationEnum of(String value) {
        switch (value) {
            case "configure":
                return OperationEnum.CONFIGURE;
            case "deconfigure":
                return OperationEnum.DECONFIGURE;
            case "set":
                return OperationEnum.SET;
            case "reset":
                return OperationEnum.RESET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute operationEnum.
     *
     * @return operationEnum value of operationEnum
     */
    public int operationEnum() {
        return operationEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
