/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules.target;

import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedulestateattributes.FutureExecutions;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State extends Augmentable  {

    /**
     * Returns the attribute futureExecutions.
     *
     * @return futureExecutions value of futureExecutions
     */
    FutureExecutions futureExecutions();

    /**
     * Sets the attribute futureExecutions.
     *
     * @param futureExecutions value of futureExecutions
     */
    void futureExecutions(FutureExecutions futureExecutions);

}