/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule;

import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.operation.OperationEnum;
import java.util.Objects;

/**
 * Represents the implementation of operation.
 */
public final class Operation {

    private OperationEnum enumeration;

    /**
     * Creates an instance of operation.
     */
    private Operation() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public Operation(OperationEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of operation for type enumeration.
     *
     * @param value value of operation for type enumeration
     * @return operation for type enumeration
     */
    public static Operation of(OperationEnum value) {
        return new Operation(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public OperationEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(OperationEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Operation) {
            Operation other = (Operation) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of operation fromString input String operation.
     *
     * @param valInString value of input String
     * @return operation
     */
    public static Operation fromString(String valInString) {
        try {
            OperationEnum tmpVal = OperationEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
