/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules.Target;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of configurationSchedules.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfigurationSchedules extends InnerModelObject implements ConfigurationSchedules {
    protected List<Target> target;

    @Override
    public List<Target> target() {
        return target;
    }

    @Override
    public void target(List<Target> target) {
        this.target = target;
    }

    @Override
    public void addToTarget(Target addTo) {
        if (target == null) {
            target = new ArrayList<>();
        }
        target.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(target);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfigurationSchedules) {
            DefaultConfigurationSchedules other = (DefaultConfigurationSchedules) obj;
            return
                Objects.deepEquals(target, other.target);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("target=" + target)
            .toString();
    }


    /**
     * Creates an instance of defaultConfigurationSchedules.
     */
    public DefaultConfigurationSchedules() {
    }

}