/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules.Target;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of configurationSchedules.
 */
public interface ConfigurationSchedules extends Augmentable  {

    /**
     * Returns the attribute target.
     *
     * @return target list of target
     */
    List<Target> target();

    /**
     * Sets the attribute target.
     *
     * @param target list of target
     */
    void target(List<Target> target);

    /**
     * Adds to the list of target.
     *
     * @param addTo value of target
     */
    void addToTarget(Target addTo);

}