/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.ConfigurationSchedules;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of actnIetfSchedule.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class ActnIetfScheduleOpParam extends InnerModelObject implements ActnIetfSchedule {
    protected ConfigurationSchedules configurationSchedules;

    @Override
    public ConfigurationSchedules configurationSchedules() {
        return configurationSchedules;
    }

    @Override
    public void configurationSchedules(ConfigurationSchedules configurationSchedules) {
        this.configurationSchedules = configurationSchedules;
    }

    @Override
    public int hashCode() {
        return Objects.hash(configurationSchedules);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ActnIetfScheduleOpParam) {
            ActnIetfScheduleOpParam other = (ActnIetfScheduleOpParam) obj;
            return
                Objects.deepEquals(configurationSchedules, other.configurationSchedules);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("configurationSchedules=" + configurationSchedules)
            .toString();
    }

    /**
     * Creates an instance of actnIetfScheduleOpParam.
     */
    public ActnIetfScheduleOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}