/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbsimpleaugment.rev20160826.ytbsimpleaugment.cont1.cont2;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ytbsimpleaugment.rev20160826.ytbsimpleaugment.cont1.cont2.augmentedcont2.Cont1s;

/**
 * Abstraction of an entity which represents the functionality of augmentedCont2.
 */
public interface AugmentedCont2 {

    /**
     * Identify the leaf of AugmentedCont2.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf4.
         */
        LEAF4(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf4.
     *
     * @return leaf4 value of leaf4
     */
    int leaf4();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute cont1s.
     *
     * @return cont1s value of cont1s
     */
    Cont1s cont1s();

    /**
     * Sets the attribute leaf4.
     *
     * @param leaf4 value of leaf4
     */
    void leaf4(int leaf4);

    /**
     * Sets the attribute cont1s.
     *
     * @param cont1s value of cont1s
     */
    void cont1s(Cont1s cont1s);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}