/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826;

import java.util.List;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.Sched;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr1.Cont;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr2.Listener;

/**
 * Abstraction of an entity which represents the functionality of ytbModuleWithContainer.
 */
public interface YtbModuleWithContainer {

    /**
     * Returns the attribute sched.
     *
     * @return sched value of sched
     */
    Sched sched();

    /**
     * Returns the attribute cont.
     *
     * @return cont value of cont
     */
    Cont cont();

    /**
     * Returns the attribute listener.
     *
     * @return listener list of listener
     */
    List<Listener> listener();

    /**
     * Sets the attribute sched.
     *
     * @param sched value of sched
     */
    void sched(Sched sched);

    /**
     * Sets the attribute cont.
     *
     * @param cont value of cont
     */
    void cont(Cont cont);

    /**
     * Sets the attribute listener.
     *
     * @param listener list of listener
     */
    void listener(List<Listener> listener);

    /**
     * Adds to the list of listener.
     *
     * @param addTo value of listener
     */
    void addToListener(Listener addTo);

}