/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule;

/**
 * Represents ENUM data of enum1Enum.
 */
public enum Enum1Enum {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int enum1Enum;
    private String schemaName;

    /**
     * Creates an instance of enum1Enum.
     *
     * @param enum1Enum value of enum1Enum
     */
     Enum1Enum(int enum1Enum, String schemaName) {
        this.enum1Enum = enum1Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of enum1Enum for.
     *
     * @param value value of enum1Enum for
     * @return enum1Enum for
     */
    public static Enum1Enum of(int value) {
        switch (value) {
            case 10:
                return Enum1Enum.TEN;
            case 100:
                return Enum1Enum.HUNDRED;
            case 1000:
                return Enum1Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of enum1Enum for.
     *
     * @param value value of enum1Enum for
     * @return enum1Enum for
     */
    public static Enum1Enum of(String value) {
        switch (value) {
            case "ten":
                return Enum1Enum.TEN;
            case "hundred":
                return Enum1Enum.HUNDRED;
            case "thousand":
                return Enum1Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute enum1Enum.
     *
     * @return enum1Enum value of enum1Enum
     */
    public int enum1Enum() {
        return enum1Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
