/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

/**
 * Represents the implementation of virtual.
 */
public abstract class Virtual extends Type {

    /**
     * Returns the attribute virtual.
     *
     * @return virtual value of virtual
     */
    public static String virtualToString() {
        return "virtual";
    }

    /**
     * Returns the object of virtual fromString input String virtual.
     *
     * @param valInString value of input String
     * @return virtual
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("virtual")) {
            return Virtual.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}